<?php
class SimplaPager extends CLinkPager{
	const CSS_HIDDEN_PAGE='hidden';
	const CSS_SELECTED_PAGE='current';
	
	public $nextPageLabel = 'N';
	public $prevPageLabel = 'P';
	public $firstPageLabel = 'F';
	public $lastPageLabel = 'L';
	public $header = '';
	
	/**
	 * Executes the widget.
	 * This overrides the parent implementation by displaying the generated page buttons.
	 */
	public function run()
	{
		$buttons=$this->createPageButtons();
		if(empty($buttons))
			return;
		echo $this->header;
		echo implode("&nbsp;",$buttons);
		echo $this->footer;
	}
	/**
	 * Creates a page button.
	 * You may override this method to customize the page buttons.
	 * @param string the text label for the button
	 * @param integer the page number
	 * @param string the CSS class for the page button. This could be 'page', 'first', 'last', 'next' or 'previous'.
	 * @param boolean whether this page button is visible
	 * @param boolean whether this page button is selected
	 * @return string the generated button
	 */
	protected function createPageButton($label,$page,$class,$hidden,$selected)
	{
		switch($label)
		{
		case 'F'	:
		return ($hidden)?'<div class="paging_back" style="text-align:left;"><span class="paging_back_inactive"> &lt;&lt; </span>':'<div class="paging_back" style="text-align:left;"><a href="'.$this->createPageUrl($page).'" id="last_page">&lt;&lt;</a>';
		 
		break;
		case 'P'     :
		return ($hidden)?'<span class="paging_back_inactive">&lt;</span></div><div class="pages">':'<a href="'.$this->createPageUrl($page).'" id="last_page">&lt;</a></div><div class="pages" style="text-align:center;">';
		break;
		case 'N':
		return ($hidden)?'</div><div class="paging_forward" style="text-align:right;"> <span class="paging_back_inactive">  &gt; </span>':'</div><div class="paging_forward" style="text-align:right;"> <a href="'.$this->createPageUrl($page).'" id="next_page">&gt;</a>';
		break;
		case 'L':
		return ($hidden)?'<span class="paging_back_inactive"> &gt;&gt; </span></div>':'<a href="'.$this->createPageUrl($page).'" id="last_page">&gt;&gt;</a></div>';
		break;
		default:
		if($selected)
		{
			return '<span class="page-links" href="#" id="current">'.$label.'</span>';
		}
		else
		{
			return '<a class="page-links" href="'.$this->createPageUrl($page).'">'.$label.'</a>';
		}
	    break;
		}
		 
 
		//echo "<p style='background:#000;color:#fff'>label:".$label."page:".$page."selected:".$selected."</p><br />";
		 
	}

	/**
	 * Creates the URL suitable for pagination.
	 * This method is mainly called by pagers when creating URLs used to
	 * perform pagination. The default implementation is to call
	 * the controller's createUrl method with the page information.
	 * You may override this method if your URL scheme is not the same as
	 * the one supported by the controller's createUrl method.
	 * @param CController the controller that will create the actual URL
	 * @param integer the page that the URL should point to. This is a zero-based index.
	 * @return string the created URL
	 */
 
}
